/**
 * 
 */
package com.sap.idm.vds.connector.samplefile.impl;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;


/**
 * Class dedicated to add files and directories
 * @author I054742
 *
 */
public class FileAdd {
	
	/**
	 * Constructor for the class FileAdd
	 */
	public FileAdd () {
	}
	
	
	/**
	 * Adds a file in the directory specified by 'path' which name will be 'fileName' and with content 'content'
	 * @param path -> Directory where the file or directory must be created
	 * @param name -> Name of the file to be created
	 * @param content -> Content of the file
	 * @param isDNDirectory -> Indicates the type of file according to the DN related with this call
	 * @return -> An integer code indicating if the operation was done successfully or not.
	 * 			  In the case of error the corresponding error code is returned
	 */
	public int add (String path, String name, String content, boolean isDNDirectory) {
		
		try {
			/* Makes sure that the path will be well formed */
			if (path.endsWith("\\")==false) path+="\\";
			
			File file = new File(path+name);
			File dir = new File(path);
			/* If the specified directory does not exist then return without creating the file */
			if (dir.isDirectory()==false) {
				return FileConstants.WRONG_PATH_CREATION_POINT;
			}
			/* If the file exists then return without creating the file */
			if (file.exists()==true) {
				return FileConstants.FILE_ALREADY_EXISTS;
			}
			
			/* If the file to be created is a normal one then it is created and the content added */
			if (isDNDirectory==false) {
				if (file.createNewFile()==false) {
					return FileConstants.IO_ERROR;
				} 
				/* Creates the file */
				RandomAccessFile fileRA = new RandomAccessFile(path+name,"rw");
				FileBasicOperations operations = new FileBasicOperations(fileRA);
				/* Adds the content */
				operations.addAtEnd(content);
				fileRA.close();
			}
			/* else then we create a directory */
			else {
				if (file.mkdir()==false) {
					return FileConstants.IO_ERROR;
				}
			}
			
			return FileConstants.SUCCESS;
		}
		catch (IOException e) {
			return FileConstants.IO_ERROR;
		}
	}
}
